#version 140
#extension GL_EXT_gpu_shader4 : enable
//Double HelixMod01.fsh by Xor
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
//https://www.shadertoy.com/view/Md3XRM
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iGlobalTime u_Elapsed


#define iTime u_Elapsed*0.3090234
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )


//#define iChannel0 sampler2D
//#define iChannel1 sampler2D
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract



vec3 LIGHT = normalize(vec3(-0.3,0.2,-0.1));

float FULL_SIZE = 2.0;
float EDGE_SIZE = 0.2;
float PAIR_SIZE = 0.2;

vec3 n3(vec3 n)
{
 	return fract(cos(dot(n,vec3(813,12,376)))*vec3(901.81,827.46,615.79));   
}
vec3 model(vec3 p)
{
    float A = p.z/3.0+iTime*0.25;
    vec3 R = vec3(cos(A),sin(A),0);
    vec3 C = vec3(mod(p.xy+8.,16.)-8.+R.yx*vec2(1,-1),fract(p.z)-0.5);
    
    float H = min(length(C.xy+R.xy*FULL_SIZE),length(C.xy-R.xy*FULL_SIZE))*0.5-EDGE_SIZE;
    float P = max(length(vec2(dot(C.xy,R.yx*vec2(1,-1)),C.z))-PAIR_SIZE,length(C.xy)-FULL_SIZE);
    
    float T = FULL_SIZE+0.01+2.*EDGE_SIZE-length(C.xy);
    return vec3(min(H,P),T,P);  
}
vec3 normal(vec3 p)
{
 	vec2 N = vec2(-0.04, 0.04);

 	return normalize(model(p+N.xyy).x*N.xyy+model(p+N.yxy).x*N.yxy+
                     model(p+N.yyx).x*N.yyx+model(p+N.xxx).x*N.xxx);
}
vec4 raymarch(vec3 p, vec3 d)
{
    vec4 M = vec4(p+d*2.0,0);
 	for(int i = 0; i<100;i++)
    {
        float S = model(M.xyz).x;
    	M += vec4(d,1) * S;
        if (S<0.01 || M.w>50.0) break;
    }
    return M;
}
vec3 sky(vec3 d)
{
    float L = dot(d,LIGHT);
 	return vec3(0.3,0.5,0.6)-0.3*(-L*0.5+0.5)+exp2(32.0*(L-1.0));   
}
vec3 color(vec3 p, vec3 d)
{
    vec2 M = model(p).yz;
    float A = atan(mod(p.y+8.,16.)-8.,8.-mod(p.x+8.,16.));
    float T1 = ceil(fract(cos(floor(p.z)*274.63))-0.5);
    float T2 = sign(fract(cos(floor(p.z-80.0)*982.51))-0.5);
    float T3 = T2*sign(cos(p.z/3.0+iTime*0.25+A));

    float L = dot(normal(p),LIGHT)*0.5+0.5;
    float R = max(dot(reflect(d,normal(p)),LIGHT),0.0);
    vec3 C = mix(mix(vec3(0.9-0.8*T3,0.9-0.6*T3,T3),vec3(1.0-0.6*T3,0.2+0.8*T3,0.1*T3),T1),vec3(0.2),step(0.01,M.y));
 	C = mix(C,vec3(0.2,0.5,1.0),step(0.01,-M.x));
    return	C*L+pow(R,16.0);
}
void main( void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 A = iMouse.xy / iResolution.xy * vec2(2,1) * 3.1416;
    vec3 D = vec3(cos(A.x)*sin(A.y),sin(A.x)*sin(A.y),cos(A.y));
    D = mix(vec3(1,0,0),D,ceil((A.x+A.y)/10.0));
    vec3 P = D*12.0-vec3(0,0,iTime*2.0);
    
    vec3 X = normalize(-D);
    vec3 Y = normalize(cross(X,vec3(0,0,1)));
    vec3 Z = normalize(cross(X,Y));
    
	vec2 UV = (gl_FragCoord.xy - iResolution.xy * 0.5) / iResolution.y;
    vec3 R = normalize(mat3(X,Y,Z) * vec3(1,UV));
    
    vec4 M = raymarch(P,R);
    vec3 C = mix(color(M.xyz,R),sky(R),smoothstep(0.5,1.0,M.w/50.0));
	gl_FragColor = vec4(C,1);
}
